<?php

namespace VendorDuplicator\Aws\Endpoint;

use ArrayAccess;
use VendorDuplicator\Aws\HasDataTrait;
use VendorDuplicator\Aws\Sts\RegionalEndpoints\ConfigurationProvider;
use VendorDuplicator\Aws\S3\RegionalEndpoint\ConfigurationProvider as S3ConfigurationProvider;
use InvalidArgumentException as Iae;
/**
 * Default implementation of an AWS partition.
 */
final class Partition implements ArrayAccess, PartitionInterface
{
    use HasDataTrait;
    private $stsLegacyGlobalRegions = ['ap-northeast-1', 'ap-south-1', 'ap-southeast-1', 'ap-southeast-2', 'aws-global', 'ca-central-1', 'eu-central-1', 'eu-north-1', 'eu-west-1', 'eu-west-2', 'eu-west-3', 'sa-east-1', 'us-east-1', 'us-east-2', 'us-west-1', 'us-west-2'];
    /**
     * The partition constructor accepts the following options:
     *
     * - `partition`: (string, required) The partition name as specified in an
     *   ARN (e.g., `aws`)
     * - `partitionName`: (string) The human readable name of the partition
     *   (e.g., "AWS Standard")
     * - `dnsSuffix`: (string, required) The DNS suffix of the partition. This
     *   value is used to determine how endpoints in the partition are resolved.
     * - `regionRegex`: (string) A PCRE regular expression that specifies the
     *   pattern that region names in the endpoint adhere to.
     * - `regions`: (array, required) A map of the regions in the partition.
     *   Each key is the region as present in a hostname (e.g., `us-east-1`),
     *   and each value is a structure containing region information.
     * - `defaults`: (array) A map of default key value pairs to apply to each
     *   endpoint of the partition. Any value in an `endpoint` definition will
     *   supersede any values specified in `defaults`.
     * - `services`: (array, required) A map of service endpoint prefix name
     *   (the value found in a hostname) to information about the service.
     *
     * @param array $definition
     *
     * @throws Iae if any required options are missing
     */
    public function __construct(array $definition)
    {
        foreach (['partition', 'regions', 'services', 'dnsSuffix'] as $key) {
            if (!isset($definition[$key])) {
                throw new Iae("Partition missing required {$key} field");
            }
        }
        $this->data = $definition;
    }
    public function getName()
    {
        return $this->data['partition'];
    }
    /**
     * @internal
     * @return mixed
     */
    public function getDnsSuffix()
    {
        return $this->data['dnsSuffix'];
    }
    public function isRegionMatch($region, $service)
    {
        if (isset($this->data['regions'][$region]) || isset($this->data['services'][$service]['endpoints'][$region])) {
            return \true;
        }
        if (isset($this->data['regionRegex'])) {
            return (bool) preg_match("@{$this->data['regionRegex']}@", $region);
        }
        return \false;
    }
    public function getAvailableEndpoints($service, $allowNonRegionalEndpoints = \false)
    {
        if ($this->isServicePartitionGlobal($service)) {
            return [$this->getPartitionEndpoint($service)];
        }
        if (isset($this->data['services'][$service]['endpoints'])) {
            $serviceRegions = array_keys($this->data['services'][$service]['endpoints']);
            return $allowNonRegionalEndpoints ? $serviceRegions : array_intersect($serviceRegions, array_keys($this->data['regions']));
        }
        return [];
    }
    public function __invoke(array $args = [])
    {
        $service = isset($args['service']) ? $args['service'] : '';
        $region = isset($args['region']) ? $args['region'] : '';
        $scheme = isset($args['scheme']) ? $args['scheme'] : 'https';
        $options = isset($args['options']) ? $args['options'] : [];
        $data = $this->getEndpointData($service, $region, $options);
        $variant = $this->getVariant($options, $data);
        if (isset($variant['hostname'])) {
            $template = $variant['hostname'];
        } else {
            $template = isset($data['hostname']) ? $data['hostname'] : '';
        }
        $dnsSuffix = isset($variant['dnsSuffix']) ? $variant['dnsSuffix'] : $this->data['dnsSuffix'];
        return ['endpoint' => "{$scheme}://" . $this->formatEndpoint($template, $service, $region, $dnsSuffix), 'signatureVersion' => $this->getSignatureVersion($data), 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['credentialScope']'';
        $sc 'signingRegion' => isset($data['                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 